$(document).ready(function() {
    $(document).on('click', '.chat-options-opener', function(e) {
        e.preventDefault();
        $('.chat-options-drowdown').remove();

        const $opener = $(this);
        const chatId = $opener.data('chat-id');
        const dataType = $opener.data('type');
        const authorPublicKey = $opener.data('author-public-key');

        let optionsList =  `<a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="cancel">
                                <i class="bi bi-x-lg"></i> Cancel
                            </a>`;

        if (dataType === 'thread') {
            optionsList += `
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="bookmark" data-chat-id="${chatId}">
                    <i class="bi bi-bookmark-plus"></i> Bookmark Thread
                </a>
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="report" data-chat-id="${chatId}">
                    <i class="bi bi-flag"></i> Report Thread
                </a>
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="block" data-author-public-key="${authorPublicKey}">
                    <i class="bi bi-slash-circle"></i> Block User
                </a>
            `;
        } else { // reply
            optionsList += `
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="blur" data-chat-id="${chatId}">
                    <i class="bi bi-eye-slash-fill"></i> Blur Chat
                </a>
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="report" data-chat-id="${chatId}">
                    <i class="bi bi-flag"></i> Report Chat
                </a>
                <a href="#" class="list-group-item list-group-item-action chat-option-item" data-action="block" data-author-public-key="${authorPublicKey}">
                    <i class="bi bi-slash-circle"></i> Block User
                </a>
            `;
        }

        const htm = $(`
            <div class="chat-options-drowdown" id="chat-options-drowdown" style="display:none;z-index:9999;" tabindex="-1">
                <div class="list-group list-group-flush">
                    ${optionsList}
                </div>
            </div>
        `);

        $opener.parent().after(htm);
        if(typeof render_bsi == 'function'){
            render_bsi();
        }
        htm.slideDown(300);
    });

    $(document).on('click', '.chat-option-item', function(e) {
        e.preventDefault();

        const $item = $(this);
        const action = $item.attr('data-action');
        const chatId = $item.attr('data-chat-id');
        const authorPublicKey = $item.attr('data-author-public-key');

        const $modal = $item.closest('.modal');

        if (action === 'cancel') {
            $('#chat-options-drowdown').slideUp(300,function(){
                $(this).remove();
            });
        } else if (action === 'report') {
            handleReportThread(chatId, $modal);
        } else if (action === 'block') {
            handleBlockUser(authorPublicKey, $modal);
        } else if (action === 'blur') {
            handleBlurChat(chatId, $modal);
        }
    });

    function handleBlurChat(chatId, $modal) {
        if (!confirm('Are you sure you want to blur this chat?')) {
            return;
        }
        $modal.modal('hide');
        alert('Blurring chat...');
    }

    function handleReportThread(chatId, $modal) {
        if (!confirm('Are you sure you want to report this thread?')) {
            return;
        }
        $modal.modal('hide');
        alert('Reporting thread...');
    }

    function handleBlockUser(authorPublicKey, $modal) {
        if (!confirm('Are you sure you want to block this user? You will no longer see their content.')) {
            return;
        }
        $modal.modal('hide');
        alert('Blocking user...');
    }
});
